* Aktualizacja (12 lipca 2016): Nowy kurs jest bardziej szczegółowy. Poruszono w nim wiele zagadnień, które nie były ujęte w jego poprzedniej wersji. Więcej informacji na ten temat znajdziesz na stronie https://www.kadenze.com/courses/creative-applications-of-deep-learning-with-tensorflow-i/info .

# Samouczek pakietu TensorFlow

Folder „python” zawiera pliki z kodem źródłowym Pythona, a folder „notebooks” zawiera zwiazane z nimi pliki Jupyter Notebook

| | Kod źródłowy | Opis |
| --- | --- | --- |
|1| **[basics.py](python/01_basics.py)** | Podstawy pakietu TensorFlow i praca z grafami.|
|2| **[linear_regression.py](python/02_linear_regression.py)** | Regresja z pojedynczym czynnikiem i wartością progową. |
|3| **[polynomial_regression.py](python/03_polynomial_regression.py)** | Regresja z czynnikami wielomianowymi. |
|4| **[logistic_regression.py](python/04_logistic_regression.py)** | Regresja logistyczna przeprowadzana przy użyciu jednowarstwowej sieci neuronowej.|
|5| **[basic_convnet.py](python/05_basic_convnet.py)** | Tworzenie głębokich sieci konwolucyjnych.|
|6| **[modern_convnet.py](python/06_modern_convnet.py)** | Głębokie sieci konwolucyjne z normalizacją masową i splotami.|
|7| **[autoencoder.py](python/07_autoencoder.py)** | Tworzenie głębokiego autoenkodera ze sztywnymi wagami.|
|8| **[denoising_autoencoder.py](python/08_denoising_autoencoder.py)** | Tworzenie głębokich autoenkoderów odszumiających modyfikujących dane wejściowe.|
|9| **[convolutional_autoencoder.py](python/09_convolutional_autoencoder.py)** | Budowa głębokiego autoenkodera konwolucyjnego.|
|10| **[residual_network.py](python/10_residual_network.py)** | Tworzenie głębokiej sieci rezydualnej.|
|11| **[variational_autoencoder.py](python/11_variational_autoencoder.py)** | Tworzenie autoenkodera z kodowaniem wariacyjnym.|

# Wskazówki dotyczące instalacji

* [Instalacja pakietu TensorFlow](https://github.com/tensorflow/tensorflow)
* [Instrukcje dla różnych systemów operacyjnych](https://github.com/tensorflow/tensorFlow/blob/master/tensorflow/g3doc/get_started/os_setup.md)
* [Instalacja w przypadku EC2 GPU](http://eatcodeplay.com/installing-gpu-enabled-tensorflow-with-python-3-4-in-ec2/)

Użytkownicy systemu Ubuntu i Pythona 3.4+ z CUDA 7.5 i cuDNN 7.0 mogą skorzystać ze skompilowanych plików znajdujących się w folderze „wheels”.  W celu zainstalowania skorzystaj z polecenia „pip3 install tensorflow-0.8.0rc0-py3-none-any.whl” i nie zapomnij o dodaniu „export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/usr/local/cuda/lib64"”
do „.bashrc”.  Skorzystanie z tych poleceń nie zwalnia z konieczności zainstalowania CUDA 7.5 i cuDNN 7.0 w folderze „/usr/local/cuda”.

# Pomoce

* [Oficjalne samouczki pakietu TensorFlow](https://www.tensorflow.org/versions/r0.7/tutorials/index.html)
* [Tensorflow API](https://www.tensorflow.org/versions/r0.7/api_docs/python/index.html)
* [Tensorflow Google Groups](https://groups.google.com/a/tensorflow.org/forum/#!forum/discuss)
* [Więcej samouczków](https://github.com/nlintz/TensorFlow-Tutorials)

# Autor

Parag K. Mital, styczeń 2016.

http://pkmital.com

# Licencja

Patrz LICENCJA.md
